/*==============================================================================
PART 3: Table A2 - Deposit Beta Statistics
==============================================================================
Purpose:
This script generates the three panels of Table 2 of the manuscript.
- Panel A: Summary statistics of the overall deposit beta for different periods.
- Panel B: Regression of deposit betas on the share of uninsured deposits.
- Panel C: Summary statistics of the decomposed insured and uninsured betas.

Input:
- $path_clean/analysis_ready_data.dta (Master dataset containing deposit
  franchise value variables)
- $path_temp/ beta_reg_PERIOD.ster (Stored regression estimates from Part 2A)

Output:
- $path_tables/table_a2_panel_a.tex (LaTeX file for Table A.2, Panel A)
- $path_tables/table_a2_panel_b.tex (LaTeX file for Table A.2, Panel B)

Last updated: July 25, 2025
==============================================================================*/

display "--- Starting Part 3A: Table A.2 ---"

**===============================================================================
* Panel A - Overall Deposit Beta Statistics
*===============================================================================
* Purpose: Generate summary statistics for the overall deposit beta (beta_depexp)
* for the periods ending Dec 2021, Feb 2023, and Feb 2024.
eststo clear
eststo: estpost summarize beta_depexp if period == "dec2021", d
eststo: estpost summarize beta_depexp if period == "feb2023", d
eststo: estpost summarize beta_depexp if period == "feb2024", d
esttab using "$path_tables/table_a2_panel_a.tex",  main(mean) aux(sd) replace ///
	prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\begin{tabular*}{0.9\textwidth}{@{\hskip\tabcolsep\extracolsep\fill}l*{3}{c}}" "\hline\hline"  "&\multicolumn{1}{c}{Dec 2021}"  " &\multicolumn{1}{c}{Feb 2023}" "&\multicolumn{1}{c}{Feb 2024}" "\\\cmidrule(lr){2-2}" "\cmidrule(lr){3-3}" "\cmidrule(lr){4-4}") ///
  coeflabels(beta_depexp "Deposit beta") ///
   nonote label ///
   sfmt(%12.0fc) nomtitles noobs scalars("N Obs.") ///
   msign($-$) alignment(c) substitute(\_ _) starlevels(* 0.10 ** 0.05 *** 0.01) ///
	postfoot("\hline\hline \end{tabular*}}")

display "--- Table A.2, Panel a created: $path_tables/table_a2_panel_a.tex ---"


**===============================================================================
* Step 3: Panel B - Deposit Beta Decomposition Regressions
*===============================================================================
* Purpose: Load the pre-computed regression results and format them into a table.

eststo clear
// Extract the estimates from the stored file & store in estout memory
local files "beta_reg_jun2019.ster beta_reg_feb2023.ster beta_reg_feb2024.ster"
foreach f of local files {
   // Extract the name from the filename (e.g., "beta_reg_feb2024.ster" -> "reg_feb2024")
   local name = subinstr(subinstr("`f'", "beta_", "", 1), ".ster", "", 1)

    display "Loading `f' and storing as `name'..."
    
    // Use the file and immediately store it with its proper name
    est use "$path_temp/`f'"
    est sto `name'
}

// Generate the LaTeX table from the loaded estimates
esttab reg_jun2019 reg_feb2023 reg_feb2024 using "$path_tables/table_a2_panel_b.tex", /// 
	prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\begin{tabular*}{\textwidth}{@{\hskip\tabcolsep\extracolsep\fill}l*{4}{c}}" ///
	"\hline\hline" "&\multicolumn{4}{c}{Deposit beta}" "\\\cmidrule(lr){2-4}") ///
	width(0.8\textwidth) nogaps ///
	b(%8.3f) se(%8.3f) sfmt(%12.0fc %9.3fc) order() ///
	coeflabels(uninsuredsh_domdep_avg "Uninsured Share" _cons "Constant") ///
	mgroups("Dec 2021" "Feb 2023" "Feb 2024", pattern(1 1 1) ///
	prefix(\multicolumn{@span}{c}{) suffix(}) ///
	span erepeat(\cmidrule(lr){@span})) ///
	noobs scalars("N Obs." "r2 \$R^2\$") ///
	msign($-$) replace nonotes nomtitles substitute(\_ _) starlevels(* 0.10 ** 0.05 *** 0.01)

display "--- Table A.2, Panel b created: $path_tables/table_a2_panel_b.tex ---"

display "--- Table A.2 generation completed ---"
